<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Session;
use Carbon\Carbon;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function login(Request $request)
    {
        // dd($request->all());

        $this->validateLogin($request);

        $url = 'https://frenzinsoftwares.com/visitor/webservice_v3/v1/customerdetail';
        $data = [
            "CustomerID" => 0,
            "device_type" => "web",
            "email" => $request->email,
            "type" => "login"
        ];

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json'
        ]);
        $loginResponse = curl_exec($ch);
        curl_close($ch);
         $loginResponse = json_decode($loginResponse);
        // dd($loginResponse);

        if($loginResponse){
            if(!$loginResponse->status){
                return redirect()->route('register');
            }
        }
        Session::put('bulk_whatsapp', $loginResponse->bulk_whatsapp);
        Session::put('checkin', $loginResponse->checkin);
        Session::put('quotation', $loginResponse->quotation);
        Session::put('location_tracking', $loginResponse->location_tracking);
        Session::put('expense', $loginResponse->expense);
         Session::put('customerDetailApiCallDateTime', Carbon::now('Asia/Kolkata'));
            Session::put('expiryDate', $loginResponse->expiry_date);
            Session::put('expiryTitle', $loginResponse->expiry_Title);
            Session::put('expiryMessage', $loginResponse->expiry_message);
            Session::put('productqr', $loginResponse?->productqr ?? 0);
            // Session::put('productqr',  0);
            Session::put('contact_detail_fields', json_decode($loginResponse->fields,true));

        // If the class is using the ThrottlesLogins trait, we can automatically throttle
        // the login attempts for this application. We'll key this by the username and
        // the IP address of the client making these requests into this application.
        if (method_exists($this, 'hasTooManyLoginAttempts') &&
            $this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);

            return $this->sendLockoutResponse($request);
        }

        if ($this->attemptLogin($request)) {
            if ($request->hasSession()) {
                $request->session()->put('auth.password_confirmed_at', time());
            }

            return $this->sendLoginResponse($request);
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        $this->incrementLoginAttempts($request);

        return $this->sendFailedLoginResponse($request);
    }

}
