<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DataTables\ActionDataTable;
use App\Models\Action;
use DB;
use Alert;
use Carbon\Carbon;

class ActionController extends Controller
{
    public function index(Request $request,ActionDataTable $dataTable)
    {
        return $dataTable->render('action.index');
        
    }
    public function addView(Request $request)
    {
        if(isset($request->id)){
            $data['Action'] = Action::where('id',$request->id)->first();
        }else{
            $data['Action'] = '';
        }
        $html = view('action.editModal',$data)->render();
        return response()->json([
            "status" => true,
            "html" => $html,
        ]);
        // return view('action.add',$data);
    }
    public function store(Request $request)
    {
        // dd($request->all());
        if($request->action == 'insert'){
            $obj = new Action();
            $obj->created_date = date('Y-m-d H:i:s');
        }else{
            $obj = Action::find($request->id);
        }
        // dd($obj);
        $obj->title = isset($request->title) ? $request->title : $obj->title;
        $obj->description = isset($request->description) ? $request->description : $obj->description;
        $obj->save();

        return response()->json([
            "status" => true,
            "message" => "You have successfully submitted data."
        ]);
       
        // Alert::success('Congrats', 'You have Successfully Data Submit');
        
        // return redirect('action/list');
    }
    public function destroy($id)
    {
        try {
            Action::where('id', $id)->delete();
            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e){
            return $e->getMessage();
        }
    }
}
