<?php

namespace App\Exports;

use App\Models\Visitor;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use DB;
class ClientDashboardVisitorslistExport implements FromView
{
    protected $customer_id;
    protected $start_date;
    protected $end_date;
    protected $action;
    
    function __construct($customer_id,$start_date,$end_date,$action) {
        $this->customer_id = $customer_id;
        $this->start_date = $start_date;
        $this->end_date = $end_date;
        $this->action = $action;
    }

    public function view(): View
    {
        return view('export.clientexportvisitor', [ 
            'query' => Visitor::getClientDashboardVisitorslistExport($this->customer_id,$this->start_date,$this->end_date,$this->action)
        ]);
    }
}
