<?php

namespace App\DataTables;

use App\Models\Sub_category;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;

class Sub_categoriesDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
            ->addColumn('action', function($row) {
                $btn = '<a data-toggle="modal" data-target="#deletePopup" data-url="'.route('sub_category.destroy',$row->id).'"  data-id="'.$row->id.'" 
                            onclick="deletePopup(this)">
                            <button class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete ">
                                <i class="fas fa-trash" aria-hidden="true"></i>
                            </button>
                        </a>';
                $btn .= '<a href="'.route('sub_category.add').'?id='.$row->id.'">
                            <button class="btn btn-primary btn-sm" data-toggle="tooltip" data-placement="left" title="Edit" style="margin-top: 0px">
                                <i class="fa fa-edit"></i>
                            </button>
                        </a>';
                return $btn;
            })
            ->rawColumns(['action']);
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\Sub_category $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Sub_category $model)
    {
        return $model->fetchAllsub_category();
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
                    ->setTableId('sub_categories-table')
                    ->columns($this->getColumns())
                    ->minifiedAjax()
                    ->dom('Bfrtip')
                    ->orderBy(1)
                    ->buttons(
                        Button::make('create'),
                        Button::make('export'),
                        Button::make('print'),
                        Button::make('reset'),
                        Button::make('reload')
                    );
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [
           
            Column::make('id'),
            Column::make('cat_name')->name('category.name')->title('Category Name'),
            Column::make('name')->title('Sub Category name'),
            // Column::make('created_at'),
            // Column::make('updated_at'),
            Column::computed('action')
            // ->exportable(false)
            // ->printable(false)
            // ->width(60)
            // ->addClass('text-center'),
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'Sub_categories_' . date('YmdHis');
    }
}
