<?php

namespace App\DataTables;

use App\Models\QuotationList;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;
use DB;

class QuotationsDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {

        return datatables()
            ->eloquent($query)
            ->editColumn('created_at', function($row) {
                return $row->created_at->format('d-m-Y');
            })
            ->editColumn('action', function($row) {
                $url = asset('uploads/quotation/'.$row->pdffile);
                $btn =  '<a  class="btn btn-sm btn-primary mr-2" href="'.$url.'" target="_blank">View</a>';
                $btn .=  '<button  class="btn btn-sm btn-danger" data-id="'.$row->id.'" data-url="'.route('quotations.destroy',$row->id).'"  onclick="deleteData(this)">Delete</button>';
                return $btn;
            })
            ->rawColumns(['created_at','action']);
        }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\QuotationList $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(QuotationList $model)
    {
        return $model->fetchQuotationList($this->start_date,$this->end_date,$this->CustomerID);
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
                    ->setTableId('quotations-table')
                    ->columns($this->getColumns())
                    ->minifiedAjax()
                    ->dom('Bfrtip')
                    ->orderBy(1)
                    // ->stateSave(true)
                    ->buttons(
                        Button::make('excel')
                    );
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [
            Column::make('id')->title('ID')->searchable(true),
            Column::make('name','visitors.name')->title('Client Name')->searchable(true),
            Column::make('company_name','visitors.company_name')->title('Company Name')->searchable(true),
            Column::make('CustomerName','users.CustomerName')->title('Team Member')->searchable(true),
            Column::make('amount')->title('Amount')->searchable(true)->class('text-center'),
            Column::make('created_at')->title('Quotation Date')->searchable(true),
            Column::computed('action')->title('Action')->searchable(false)
            
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'Quotations_' . date('YmdHis');
    }
}