<?php

namespace App\DataTables;

use App\Models\EventUser;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;
use DB;
class EventUsersDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
            ->addColumn('action', '')
            ->editColumn('is_admin1', function ($row) {

                $userid =$row->user_id;
                $fkuserid =DB::table('event_assignments')
                ->select('users.user_id','event_assignments.*')
                ->leftjoin('users', 'users.user_id', 'event_assignments.fk_user_id')
                ->where('event_assignments.fk_user_id', $userid)
                ->where('event_assignments.fk_event_id', $this->eventid)
                ->first();
        
                if($fkuserid) {
                    $selected = "checked";
                } else {
                    $selected = "";
                }
                return '<input type="checkbox" name="customerids[]" '.$selected.' data-user_id="'.$row->user_id.'" id="is_admin" value="'.$row->user_id.'">';
            })->rawColumns(['action', 'is_admin1']);
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\EventUser $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(EventUser $model)
    {
        return $model->fetchAllUsers();
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
                    ->setTableId('eventusers-table')
                    ->columns($this->getColumns())
                    ->minifiedAjax()
                    ->dom('Bfrtip')
                    //  ->stateSave(true) // Enable state saving
                    ->orderBy(1)
                    ->paging(false) // Disable pagination
                    ->searching(false) // Disable search functionality
                    ->buttons(
                        Button::make('create'),
                        Button::make('export'),
                        Button::make('print'),
                        Button::make('reset'),
                        Button::make('reload')
                    );
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [
           
            Column::make('CustomerID')->title('Customer_ID'),
            Column::make('CustomerName')->title('Name'),
            Column::computed('is_admin1')->title(''),
           
            // Column::computed('action')
            //       ->exportable(false)
            //       ->printable(false)
            //       ->width(60)
            //       ->addClass('text-center'),
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'EventUsers_' . date('YmdHis');
    }
}