<?php

namespace App\DataTables;

use App\Models\Visitor;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;
use DB;
use App\Models\Product;

class ClientUserDataTable extends DataTable
{
    public function query(Visitor $model)
    {
        // $companyName = urldecode(request()->id);
        // $companyName = request('id');
         $companyName = request('company_name');

        // $visitorName = request()->visitor_name;
        $visitorName = trim(request('visitor_name'));
        $attendBy = trim(request('attend_by'));

        $query = DB::table('visit_data')
            ->join('visitors', 'visitors.id', '=', 'visit_data.fk_visitor_id')
            ->leftJoin('events', 'events.id', '=', 'visitors.event_id')
            // ->leftJoin('users', 'users.CustomerID', '=', 'visitors.customer_id')
            // ->whereRaw('LOWER(visitors.id) = ?', [strtolower($companyName)]);
            ->where('visitors.id', $companyName);

        if (!empty($visitorName)) {
            $query->where('visitors.name', $visitorName);
        }
        if (!empty($attendBy)) {
            $query->where('visit_data.attend_by', $attendBy);
        }
        return $query->select(
            'visit_data.id',
            'visitors.id as visitor_id',
            'visitors.name as visitor_name',
            'visitors.mobile_no',
            'visitors.email',
            'visitors.company_name',
            'visitors.event_id',          // ✅ REQUIRED
            'visitors.event_ids',
            'events.event_name',
            'visit_data.action',
            'visit_data.remarks',
            'visit_data.visit_time',
            'visit_data.attend_by as team_member'
        );
    }


    public function dataTable($query)
    {
        return datatables()
            ->of($query)
            ->filter(function ($query) {
                if ($search = request('search')['value'] ?? null) {
                    $query->where(function ($q) use ($search) {
                        $q->where('visitors.name', 'like', "%{$search}%")
                            ->orWhere('visitors.mobile_no', 'like', "%{$search}%")
                            ->orWhere('visitors.email', 'like', "%{$search}%")
                            ->orWhere('events.event_name', 'like', "%{$search}%")
                            ->orWhere('visit_data.action', 'like', "%{$search}%")
                            ->orWhere('visit_data.remarks', 'like', "%{$search}%")
                            ->orWhere('visit_data.visit_time', 'like', "%{$search}%")
                            ->orWhere('visit_data.attend_by', 'like', "%{$search}%");
                    });
                }
            })
            ->editColumn('event_name', function ($row) {

                $event_id = $row->event_id;
                $eventIds = explode(',', $row->event_ids ?? '');

                $eventIds = array_filter($eventIds, function ($id) use ($event_id) {
                    return $id != $event_id;
                });

                $eventIds = array_values($eventIds);
                $eventNames = [];

                if (!empty($eventIds)) {
                    $eventNames = DB::table('events')
                        ->whereIn('id', $eventIds)
                        ->pluck('event_name')
                        ->toArray();
                }

                $eventNamesString = implode(', ', $eventNames);
                $styledEventNames = $eventNames
                    ? "<span style='color: gray;'>$eventNamesString</span>"
                    : '';

                return "<span style='color:#007bff;'>$row->event_name</span>" . ($eventNames ? ' , ' . $styledEventNames : '');
            })
            ->editColumn('visitor_name', function ($row) {
                $action = '<a href="' . route('visitor.detail') . '?id=' . $row->visitor_id . '" >
                                        ' . $row->visitor_name . '
                            </a>';
                return $action;
            })
            ->editColumn(
                'visit_time',
                fn($row) =>
                $row->visit_time ? date('d-m-Y g:i A', strtotime($row->visit_time)) : '-'
            )

            ->rawColumns(['event_name', 'visitor_name']);
    }


    public function html()
    {
        // return $this->builder()
        //     ->setTableId('company-visit-table')
        //     ->addTableClass('company-visit-dt')
        //     ->columns($this->getColumns())
        //     ->minifiedAjax()
        //     ->dom('frtip')
        //     ->orderBy(5);
        return $this->builder()
            ->setTableId('company-visit-table')
            ->addTableClass('company-visit-dt')
            ->columns($this->getColumns())
            ->ajax([
                'url' => route('visitor.company.visits.ajax'),
                'data' => 'function(d){
                
                d.company_name = $("input[name=company_name]").val();
            }'
            ])
            ->dom('frtip')
            ->orderBy(5);
    }

    protected function getColumns()
    {
        return [
            Column::make('visitor_name')->title('Client Name'),
            Column::make('event_name')->title('Event/Folder_Name'),
            Column::make('team_member')->title('Team Member'),
            Column::make('mobile_no')->title('Mobile'),
            Column::make('email')->title('Email'),
            Column::make('visit_time')->title('Visited Date'),
            Column::make('action')->title('Visit Action'),
            Column::make('remarks')->title('Remarks'),
        ];
    }
}
